/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.item;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.renderer.item.TatteredTomeModel;
import com.hollingsworth.arsnouveau.common.items.WornNotebook;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.util.Color;

public class TatteredTomeRenderer
extends GeoItemRenderer<WornNotebook> {
    public TatteredTomeRenderer() {
        super((GeoModel)new TatteredTomeModel());
    }

    public void actuallyRender(PoseStack poseStack, WornNotebook animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int packedColor) {
        model.getBone("tier3").ifPresent(bone -> bone.setHidden(true));
        model.getBone("tier1").ifPresent(bone -> bone.setHidden(false));
        model.getBone("tier2").ifPresent(bone -> bone.setHidden(true));
        super.actuallyRender(poseStack, (Item)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, packedColor);
    }

    protected void renderInGui(ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, float partialTick) {
        MultiBufferSource.BufferSource bufferSource2;
        if (this.useEntityGuiLighting) {
            Lighting.setupForEntityInInventory();
        } else {
            Lighting.setupForFlatItems();
        }
        int color = this.getRenderColor((GeoAnimatable)((WornNotebook)this.animatable), partialTick, packedLight).argbInt();
        MultiBufferSource.BufferSource var10000 = bufferSource instanceof MultiBufferSource.BufferSource ? (bufferSource2 = (MultiBufferSource.BufferSource)bufferSource) : Minecraft.getInstance().renderBuffers().bufferSource();
        MultiBufferSource.BufferSource defaultBufferSource = var10000;
        RenderType renderType = this.getRenderType((WornNotebook)this.animatable, this.getTextureLocation((WornNotebook)this.animatable), (MultiBufferSource)defaultBufferSource, partialTick);
        VertexConsumer buffer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)true, (this.currentItemStack != null && this.currentItemStack.hasFoil() ? 1 : 0) != 0);
        poseStack.pushPose();
        this.defaultRenderGui(poseStack, (WornNotebook)this.animatable, (MultiBufferSource)defaultBufferSource, renderType, buffer, 0.0f, partialTick, packedLight, packedOverlay, color);
        defaultBufferSource.endBatch();
        RenderSystem.enableDepthTest();
        Lighting.setupFor3DItems();
        poseStack.popPose();
    }

    public void defaultRender(PoseStack poseStack, WornNotebook animatable, MultiBufferSource bufferSource, @javax.annotation.Nullable RenderType renderType, @javax.annotation.Nullable VertexConsumer buffer, float yaw, float partialTick, int packedLight) {
        super.defaultRender(poseStack, (GeoAnimatable)animatable, bufferSource, renderType, buffer, yaw, partialTick, packedLight);
    }

    public void defaultRenderGui(PoseStack poseStack, WornNotebook animatable, MultiBufferSource bufferSource, @javax.annotation.Nullable RenderType renderType, @javax.annotation.Nullable VertexConsumer buffer, float yaw, float partialTick, int packedLight, int packedOverlay, int packedColor) {
        poseStack.pushPose();
        Color renderColor = this.getRenderColor((GeoAnimatable)animatable, partialTick, packedLight);
        float red = renderColor.getRedFloat();
        float green = renderColor.getGreenFloat();
        float blue = renderColor.getBlueFloat();
        float alpha = renderColor.getAlphaFloat();
        BakedGeoModel model = this.model.getBakedModel(this.model.getModelResource((GeoAnimatable)animatable));
        if (renderType == null) {
            renderType = this.getRenderType(animatable, this.getTextureLocation(animatable), bufferSource, partialTick);
        }
        if (buffer == null) {
            buffer = bufferSource.getBuffer(renderType);
        }
        this.preRender(poseStack, animatable, model, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, packedColor);
        if (this.firePreRenderEvent(poseStack, model, bufferSource, partialTick, packedLight)) {
            this.preApplyRenderLayers(poseStack, (GeoAnimatable)animatable, model, renderType, bufferSource, buffer, packedLight, packedLight, packedOverlay);
            this.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, packedColor);
            this.applyRenderLayers(poseStack, (GeoAnimatable)animatable, model, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
            this.postRender(poseStack, (GeoAnimatable)animatable, model, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, packedColor);
            this.firePostRenderEvent(poseStack, model, bufferSource, partialTick, packedLight);
        }
        poseStack.popPose();
        this.renderFinal(poseStack, (GeoAnimatable)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, packedColor);
    }

    public ResourceLocation getTextureLocation(WornNotebook o) {
        return ArsNouveau.prefix("textures/item/tattered_tome.png");
    }

    public RenderType getRenderType(WornNotebook animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)texture);
    }
}

